######################################################################
#	Imports and Variables
######################################################################
import time
from sys import argv
from graph_tool.all import *    # Graph, Vertex, Edge objects
#from graph_tool.util import *   # Required for find_vertex()
global g


######################################################################
#	Functions
######################################################################
# initialise()
#   Initialise script variables
#   Params:     (none)
#   Returns:    (none)
def initialise():
    global g, vertices, go
    go = time.time()
    vertices = {}
    g = Graph()
    g.vp.id   = g.new_vertex_property("string")
    g.vp.name = g.new_vertex_property("string")
    g.vp.kind = g.new_vertex_property("string")
    g.ep.kind = g.new_edge_property("string")
    g.vp.where = g.new_vertex_property("vector<double>")
    g.vp.color = g.new_vertex_property("vector<double>")
    g.ep.color = g.new_edge_property("vector<double>")
    g.vp.shape = g.new_vertex_property("vector<double>")
    g.vp.btwn = g.new_vertex_property("double")
    g.ep.btwn = g.new_edge_property("double")

def elapsed():
    global go
    return round((time.time() - go), 3)

def importData(text_f, graph_f):
    global g, lno
    lno = 0
    print('Processing input file...%d' %elapsed())
    with open(text_f, "r") as fileIn:
        for line in fileIn:
            processLine(line)
            lno +=1
    print('...imported...%d' %elapsed())
    print('Writing graph to file...%d' %elapsed())
    g.save(graph_f)
    print('...done...%d' %elapsed())

def processLine(line):
    global g
    ids = line[:-1].split('\t')
    if exclude(ids[0]) or exclude(ids[1]): return
    v_from = get_v(ids[0])
    v_to   = get_v(ids[1])
    e = g.add_edge(v_from, v_to)
    g.ep.kind[e] = g.vp.kind[v_from] + '_' + g.vp.kind[v_to]
    if len(ids) == 4:
        g.vp.name[v_from] = ids[2]
        g.vp.name[v_to]   = ids[2]+'::'+ids[3]

def exclude(id):
    try:
        if id[0] == '9': return True
        if (len(id) > 4 and id[5] == '9'): return True
    except:
        print('%d\t|%s|' %(lno, id))
        raise
    return False

def get_v(id):
    global g
    v = vertices.get(id)
    if not v:
        v = g.add_vertex()  # If the vertex doesn't exist, create it
        vertices[id] = v
        g.vp.id[v] = id
        g.vp.kind[v] = 't' if len(id) == 4 else 'm'
    return v

def between(graph_f, graph_b_f):
    g = load_graph(graph_f)
    print('Betweenness...%d' %elapsed())
    g.vp.btwn, g.ep.btwn = betweenness(g, vprop = g.vp.btwn, eprop = g.ep.btwn)
    g.save(graph_b_f)
    print('...between done...%d' %elapsed())

def list_v(graph_f, list_f):
    print('Taking v list...%d' %elapsed())
    g = load_graph(graph_f)
    ids   = g.vp.id
    names = g.vp.name
    #locs  = g.vp.where
    with open(list_f, 'w') as outf:
        for v in g.vertices():
            id   = ids[v]
            name = names[v]
            if len(name) < 1: continue
            if name[-1] == '\n':
                name = name[:-1]
                names[v] = name
            outf.write("%s\t%s\t%.6f\t%6d\t%6d\n" %(id, name, g.vp.btwn[v], v.in_degree(), v.out_degree()))
    print('...listed...%d' %elapsed())

def list_e(graph_f, list_f):    # assumes names cleaned up in list_v
    print('Taking e list...%d' %elapsed())
    g = load_graph(graph_f)
    ids   = g.vp.id
    names = g.vp.name
    #locs  = g.vp.where
    with open(list_f, 'w') as outf:
        for e in g.edges():
            id_s   = ids[e.source()]
            id_t   = ids[e.target()]
            name_s = names[e.source()]
            name_t = names[e.target()]
            outf.write("%s>%s\t%s>%s\t%.6f\t%6d\t%6d\n" %(id_s, id_t, name_s, name_t, g.ep.btwn[e], e.source().out_degree(), e.target().in_degree()))
    print('...listed...%d' %elapsed())


######################################################################
#	Main
######################################################################
if __name__ == "__main__":
#     if(len(argv) != 3):
#         print("ERROR - Invalid Parameters\nUsage: %s {inputFileName} {outputFileName}" % argv[0])
#         exit()
#     initialise()
#     importData(argv[1])
#     saveToDisk(argv[2])
    initialise()
    importData('./grf_sx.txt','./grf_c.gt')
    between('./grf_c.gt', './grf_cb.gt')
    list_v('./grf_cb.gt', './grf_list_cv.txt')
    list_e('./grf_cb.gt', './grf_list_ce.txt')
